﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations.Schema;

namespace QualityManagement.Data.Entities;
public class Audit : BaseEntity
{
    public Guid Id { get; set; }
    public string Title { get; set; }
    public string AuditNumber { get; set; }
    public Guid AuditTemplateId { get; set; }
    [ForeignKey("AuditTemplateId")]
    public AuditTemplate AuditTemplate { get; set; }
    public Guid AuditorId { get; set; }
    [ForeignKey("AuditorId")]
    public User Auditor { get; set; }
    public AUDIT_STATUS Status { get; set; }
    public decimal EffectiveScore { get; set; }
    public decimal TotalScore { get; set; }
    public ICollection<NonConformance> NonConformances { get; set; } = new List<NonConformance>();
    public ICollection<CapaRequest> CapaRequests { get; set; } = new List<CapaRequest>();
    public ICollection<AuditResponse> AuditResponses { get; set; } = new List<AuditResponse>();
    public ICollection<AuditReviewer> AuditReviewers { get; set; } = new List<AuditReviewer>();
    public ICollection<AuditReviewComment> AuditReviewComments { get; set; } = new List<AuditReviewComment>();

}

public enum AUDIT_STATUS
{
    CREATED = 1,
    INPROGRESS = 2,
    COMPLETED = 3,
    CLOSED = 4,
    INREVIEW = 5,
    REJECTED = 6,
    REWORK = 7
}
