﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations.Schema;

namespace QualityManagement.Data.Entities;
public class AuditResponse : BaseEntity
{
    public Guid Id { get; set; }
    public Guid AuditId { get; set; }
    [ForeignKey("AuditId")]
    public Audit Audit { get; set; }
    public int Score { get; set; }
    public Guid QuestionId { get; set; }
    [ForeignKey("QuestionId")]
    public AuditTemplateQuestion Question { get; set; }
    public string Response { get; set; }
    public List<AuditResponseAttachment> AuditResponseAttachments { get; set; }
    public List<NonConformance> NonConformances { get; set; }
    public List<CapaRequest> CapaRequests { get; set; }
}

