﻿using System;
using System.ComponentModel.DataAnnotations.Schema;

namespace QualityManagement.Data.Entities;
public class AuditReviewer
{
    public Guid Id { get; set; }
    public Guid AuditId { get; set; }
    [ForeignKey("AuditId")]
    public Audit Audit { get; set; }
    public Guid? ReviewerId { get; set; }
    [ForeignKey("ReviewerId")]
    public User Reviewer { get; set; }
    public Guid? SubmitterId { get; set; }
    [ForeignKey("SubmitterId")]
    public User Submitter { get; set; }
    public string Comments { get; set; }
    public DateTime ReviewedOn { get; set; }
    public AUDIT_STATUS AuditStatus { get; set; }
}
