﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations.Schema;

namespace QualityManagement.Data.Entities;
public class AuditTemplate : BaseEntity
{
    public Guid Id { get; set; }
    public string Name { get; set; }
    public string Description { get; set; }
    public AUDIT_TYPE AuditType { get; set; }
    public string IconName { get; set; }
    public Guid? DepartmentId { get; set; }
    [ForeignKey("DepartmentId")]
    public Department Department { get; set; }
    public bool IsActive { get; set; }
    public ICollection<Audit> Audits { get; set; } = new List<Audit>();
    public ICollection<AuditTemplateQuestion> Questions { get; set; } = new List<AuditTemplateQuestion>();
}

public enum AUDIT_TYPE
{
    ALL = 0,
    INTERNAL = 1,
    EXTERNAL = 2,
    SUPPLIER = 3
}
