﻿using System;
using System.ComponentModel.DataAnnotations.Schema;

namespace QualityManagement.Data.Entities;
public class CapaAction : BaseEntity
{
    public Guid Id { get; set; }
    public Guid CapaRequestId { get; set; }
    [ForeignKey("CapaRequestId")]
    public CapaRequest CapaRequest { get; set; }
    public CapaActionType ActionType { get; set; }
    public string ActionDescription { get; set; }
    public Guid? AssignToId { get; set; }
    [ForeignKey("AssignToId")]
    public User AssignTo { get; set; }
    public CapaActionStatus Status { get; set; }
    public DateTime? DueDate { get; set; }
    public DateTime? CompletedDate { get; set; }
    [ForeignKey("CreatedBy")]
    public User CreatedByUser { get; set; }
}

public enum CapaActionType
{
    PREVENTIVE,
    CORRECTIVE
}
public enum CapaActionStatus
{
    All,
    PENDING,
    INPROGRESS,
    REJECTED,
    COMPLETED
}

