﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations.Schema;

namespace QualityManagement.Data.Entities;
public class CapaAttachment : BaseEntity
{
    public Guid Id { get; set; }
    public string FilePath { get; set; }
    public string FileName { get; set; }
    public long FileSize { get; set; }
    public string Extension { get; set; }
    public string Description { get; set; }
    public Guid CapaRequestId { get; set; }
    public CapaRequest CapaRequest { get; set; }
    public Guid? StorageSettingId { get; set; }
    [ForeignKey("StorageSettingId")]
    public StorageSetting StorageSetting { get; set; }
    public byte[] Key { get; set; } = null;
    public byte[] IV { get; set; } = null;
    public bool IsAllChunkUploaded { get; set; }
    public int TotalChunk { get; set; }

    public ICollection<CapaAttachmentChunk> CapaAttachmentChunks { get; set; } = new List<CapaAttachmentChunk>();
}
