﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations.Schema;

namespace QualityManagement.Data.Entities;
public class CapaRequest : BaseEntity
{
    public Guid Id { get; set; }
    public string ReferenceNo { get; set; } //Auto_Generated_Number
    public string Title { get; set; }
    public string Description { get; set; }
    public Guid? RaisedById { get; set; }
    [ForeignKey("RaisedById")]
    public User RaisedBY { get; set; }
    public Guid? NonConformanceId { get; set; }
    [ForeignKey("NonConformanceId")]
    public NonConformance NonConformance { get; set; }
    public Guid? AuditId { get; set; }
    [ForeignKey("AuditId")]
    public Audit Audit { get; set; }
    public CapaRequestStatus CapaRequestStatus { get; set; }
    public CapaRequestPriority Priority { get; set; }
    public DateTime? DueDate { get; set; }
    public Guid? AuditResponseId { get; set; }
    [ForeignKey("AuditResponseId")]
    public AuditResponse AuditResponse { get; set; }
    public ICollection<CapaAction> CapaActions { get; set; } = new List<CapaAction>();
    public ICollection<CapaRootCause> CapaRootCauses { get; set; } = new List<CapaRootCause>();
    public ICollection<CapaAttachment> CapaAttachments { get; set; } = new List<CapaAttachment>();
    public ICollection<CapaReview> CapaReviews { get; set; } = new List<CapaReview>();
    public ICollection<AuditResponse> AuditResponses { get; set; } = new List<AuditResponse>(); 

}

public enum CapaRequestPriority
{
    LOW = 1,
    MEDIUM = 2,
    HIGH = 3,
    CRITICAL = 4
}
public enum CapaRequestStatus
{
    OPEN = 1,
    INPROGRESS = 2,
    CLOSED = 3,
    REVIEWED = 4,
    REJECTED = 5
}
