﻿using System;
using System.ComponentModel.DataAnnotations.Schema;

namespace QualityManagement.Data.Entities;
public class ComplaintComment
{
    public Guid Id { get; set; }
    public Guid ComplaintId { get; set; }
    [ForeignKey("ComplaintId")]
    public Complaint Complaint { get; set; }
    public string CommentText { get; set; }
    public DateTime CommentedAt { get; set; }
    public Guid CommentedById { get; set; } // User ID of the person who created the comment
    [ForeignKey("CommentedById")]
    public User CommentedBy { get; set; }

}
