﻿using System;
using System.ComponentModel.DataAnnotations.Schema;

namespace QualityManagement.Data.Entities;
public class ComplaintLog
{
    public Guid Id { get; set; }
    public Guid ComplaintId { get; set; }
    public string ComplaintNo { get; set; }
    public string Title { get; set; }
    public string Description { get; set; }
    public DateTime ComplaintDate { get; set; }
    public ReportedByEnum ReportedBy { get; set; }
    public Guid? AssignedToId { get; set; }
    [ForeignKey("AssignedToId")]
    public User AssignedTo { get; set; }
    public Guid ComplaintTypeId { get; set; }
    [ForeignKey("ComplaintTypeId")]
    public ComplaintType ComplaintType { get; set; }
    public LogStatus LogStatus { get; set; }
    public ComplaintPriorityEnum Priority { get; set; }
    public ComplaintStatusEnum Status { get; set; }
    public string ResolutionSummary { get; set; }
    public Guid CreatedBy { get; set; }
    [ForeignKey("CreatedBy")]
    public User CreatedByUser { get; set; }
    public DateTime CreatedDate { get; set; } = DateTime.UtcNow;
}
