﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations.Schema;

namespace QualityManagement.Data.Entities;
//This table logs the non-conformance details.
public class NonConformance : BaseEntity
{
    public Guid Id { get; set; }
    public string Title { get; set; }
    public string NCNumber { get; set; }
    public Guid ReportedById { get; set; }
    [ForeignKey("ReportedById")]
    public User ReportedBy { get; set; }
    public Guid? DepartmentId { get; set; }
    [ForeignKey("DepartmentId")]
    public Department Department { get; set; }
    public string Description { get; set; }
    public NonConformanceSeverity Severity { get; set; }
    public NonConformanceStatus Status { get; set; }
    public DateTime? ClosedDate { get; set; }
    public Guid? AuditId { get; set; }
#nullable enable
    public Audit? Audit { get; set; }
    public Guid? AuditResponseId { get; set; }
    [ForeignKey("AuditResponseId")]
    public AuditResponse AuditResponse { get; set; }
    public ICollection<CapaRequest> CapaRequests { get; set; } = new List<CapaRequest>();
    public ICollection<NonConformanceResponse> NonConformanceResponses { get; set; } = new List<NonConformanceResponse>();
    public ICollection<AuditResponse> AuditResponses { get; set; } = new List<AuditResponse>();
}

public enum NonConformanceType
{
    PRODUCT,
    PROCESS,
    SUPPLIER,
    SAFETY
}

public enum NonConformanceStatus
{
    OPEN,
    INPROGRESS,
    CLOSED,
    REJECTED
}

public enum NonConformanceSeverity
{
    LOW,
    MEDIUM,
    HIGH,
    CRITICAL
}


