﻿using System;
using System.ComponentModel.DataAnnotations.Schema;

namespace QualityManagement.Data.Entities;
public class NonConformanceLog
{
    public Guid Id { get; set; }
    public Guid NonConformanceId { get; set; }
    public string Title { get; set; }
    public string NCNumber { get; set; }
    public Guid ReportedById { get; set; }
    [ForeignKey("ReportedById")]
    public User ReportedBy { get; set; }
    public Guid? DepartmentId { get; set; }
    [ForeignKey("DepartmentId")]
    public Department Department { get; set; }
    public string Description { get; set; }
    public LogStatus LogStatus { get; set; }
    public NonConformanceSeverity Severity { get; set; }
    public NonConformanceStatus Status { get; set; }
    public DateTime? ClosedDate { get; set; }
    public Guid? AuditId { get; set; }
    [ForeignKey("AuditId")]
    public Audit Audit { get; set; }
    public Guid CreatedBy { get; set; }
    [ForeignKey("CreatedBy")]
    public User CreatedByUser { get; set; }
    public DateTime CreatedDate { get; set; } = DateTime.UtcNow;
}
