﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations.Schema;

namespace QualityManagement.Data.Entities;
//This table records responses, actions taken, and follow-up for each non-conformance.
public class NonConformanceResponse : BaseEntity
{
    public Guid Id { get; set; }
    public string Title { get; set; }
    public Guid NonConformanceId { get; set; }
    [ForeignKey("NonConformanceId")]
    public NonConformance NonConformance { get; set; }
    public Guid? NonConformanceResponseTypeId { get; set; }
    [ForeignKey("NonConformanceResponseTypeId")]
    public NonConformanceResponseType ResponseType { get; set; }
    public string ResponseDescription { get; set; }
    public Guid? ResponsiblePersonId { get; set; }
    [ForeignKey("ResponsiblePersonId")]
    public User ResponsiblePerson { get; set; }
    public DateTime? DueDate { get; set; }
    public DateTime? CompletionDate { get; set; }
    public bool IsEffective { get; set; }
    public Guid? VerifiedById { get; set; }
    [ForeignKey("VerifiedById")]
    public User VerifiedBy { get; set; }
    public DateTime? VerificationDate { get; set; }
    public ICollection<NonConformanceRespAttachment> NonConformanceRespAttachments { get; set; } = new List<NonConformanceRespAttachment>();

}
