﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations.Schema;

namespace QualityManagement.Data.Entities;
public class RiskAttachment
{
    public Guid Id { get; set; }
    public Guid RiskId { get; set; }
    [ForeignKey("RiskId")]
    public Risk Risk { get; set; }
    public string FileName { get; set; }
    public string FilePath { get; set; }
    public long FileSize { get; set; }
    public string Extension { get; set; }
    public string Description { get; set; }
    public byte[] Key { get; set; } = null;
    public byte[] IV { get; set; } = null;
    public Guid? StorageSettingId { get; set; }
    public StorageType StorageType { get; set; }
    public int TotalChunk { get; set; }
    public DateTime UploadedDate { get; set; }
    public Guid UploadedById { get; set; } // Could be a UserId or username
    [ForeignKey("UploadedById")]
    public User UploadedBy { get; set; }
    public bool IsAllChunkUploaded { get; set; }
    public ICollection<RiskAttachmentChunk> RiskAttachmentChunks { get; set; }
}
