﻿using QualityManagement.Data.Entities.RiskManagment;
using System;
using System.ComponentModel.DataAnnotations.Schema;

namespace QualityManagement.Data.Entities;
public class RiskControl
{
    public Guid Id { get; set; }
    public string Title { get; set; }
    public string Description { get; set; }
    public Guid RiskId { get; set; }
    [ForeignKey("RiskId")]
    public Risk Risk { get; set; }
    public ControlTypeEnum ControlType { get; set; } // e.g., Mitigation, Avoidance, Transfer
    public DateTime ImplementationDate { get; set; }
    public DateTime? ReviewDate { get; set; }
    public RiskStatusEnum Status { get; set; } // e.g., Planned, In Progress, Completed
    public Guid ResponsibleId { get; set; }
    [ForeignKey("ResponsibleId")]
    public User ResponsibleBy { get; set; }
    public EffectivenessEnum Effectiveness { get; set; }
}
