﻿using System;
using System.ComponentModel.DataAnnotations.Schema;

namespace QualityManagement.Data.Entities;
//Internal or external audits of suppliers.
public class SupplierAudit
{
    public Guid Id { get; set; } // Unique identifier for the audit record
    public Guid SupplierId { get; set; } // Foreign key to the Supplier entity
    [ForeignKey("SupplierId")]
    public Supplier Supplier { get; set; }
    public DateTime AuditDate { get; set; } // Date when the audit was conducted
    public Guid AuditorId { get; set; } // User or organization that conducted the audit
    [ForeignKey("AuditorId")]
    public User Auditor { get; set; }
    public SupplierAuditTypeEnum AuditType { get; set; } // Type of audit (e.g., internal, external)
    public string Findings { get; set; } // Summary of findings from the audit
    public int Score { get; set; } // Score out of 100
    public string Result { get; set; } // Status of the audit (e.g., Pass / Fail / Conditional)
}
