﻿using System;
using System.ComponentModel.DataAnnotations.Schema;

namespace QualityManagement.Data.Entities;
//Tracks supplier pre-qualification and approval process.
public class SupplierQualification
{
    public Guid Id { get; set; } // Unique identifier for the qualification record
    public Guid SupplierId { get; set; } // Foreign key to the Supplier entity
    [ForeignKey("SupplierId")]
    public Supplier Supplier { get; set; }
    public DateTime QualificationDate { get; set; } // Date when the qualification was obtained
    public Guid QualifiedById { get; set; } // Organization or authority that issued the qualification
    [ForeignKey("QualifiedById")]
    public User QualifiedBy { get; set; }
    public string Criteria { get; set; } //	Summary of evaluation criteria
    public string Result { get; set; }    //Qualified / Not Qualified / Pending
    public string Remarks { get; set; } //Comments or observations

}
