﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Security.Cryptography;
using System.Text;
using System.Threading.Tasks;

namespace QualityManagement.Helper
{
    public static class GeneratCourceLink
    {
        public static string GenerateLink(string plainText)
        {
            // 16 bytes = 128 bits of entropy (like a GUID)
            var randomBytes = new byte[32];
            using (var rng = RandomNumberGenerator.Create())
            {
                rng.GetBytes(randomBytes);
            }

            // Base64 encode and make URL-safe
            var token = Convert.ToBase64String(randomBytes)
                .Replace("+", "-")
                .Replace("/", "_")
                .Replace("=", ""); // remove padding

            return token;
        }
    }
}
