﻿using QualityManagement.Common.UnitOfWork;
using QualityManagement.Domain;
using QualityManagement.Helper;
using QualityManagement.Repository;
using MediatR;
using Microsoft.EntityFrameworkCore;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR;
public class DeleteAIPromptTemplateCommandHandler(IAIPromptTemplateRepository aIPromptTemplateRepository,
     IUnitOfWork<QMSDbContext> _uow) : IRequestHandler<DeleteAIPromptTemplateCommand, ServiceResponse<bool>>
{
    public async Task<ServiceResponse<bool>> Handle(DeleteAIPromptTemplateCommand request, CancellationToken cancellationToken)
    {
        var entityExist = await aIPromptTemplateRepository.All.FirstOrDefaultAsync(c => c.Id == request.Id);
        if (entityExist == null)
        {
            return ServiceResponse<bool>.Return409("Name already exists.");
        }

        aIPromptTemplateRepository.Remove(entityExist);
        if (await _uow.SaveAsync() <= 0)
        {
            return ServiceResponse<bool>.Return500();
        }
        return ServiceResponse<bool>.ReturnResultWith201(true);
    }
}
