﻿using QualityManagement.Data.Entities;
using QualityManagement.Helper;
using QualityManagement.Repository;
using MediatR;
using Microsoft.EntityFrameworkCore;
using System.Collections.Generic;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR;
public class GetAllAIPromptTemplateCommandHandler(IAIPromptTemplateRepository aIPromptTemplateRepository) : IRequestHandler<GetAllAIPromptTemplateCommand, ServiceResponse<List<AIPromptTemplate>>>
{
    public async Task<ServiceResponse<List<AIPromptTemplate>>> Handle(GetAllAIPromptTemplateCommand request, CancellationToken cancellationToken)
    {
        var aIPromptTemplates = await aIPromptTemplateRepository.All.ToListAsync(cancellationToken: cancellationToken);
        //if (aIPromptTemplates == null || aIPromptTemplates.Count == 0)
        //{
        //    return ServiceResponse<List<AIPromptTemplate>>.Return404("AI Prompt Template not found.");
        //}
        return ServiceResponse<List<AIPromptTemplate>>.ReturnResultWith200(aIPromptTemplates);
    }
}
