﻿using QualityManagement.Common.UnitOfWork;
using QualityManagement.Data.Dto;
using QualityManagement.Domain;
using QualityManagement.Helper;
using QualityManagement.Repository;
using MediatR;
using Microsoft.Extensions.Logging;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class DeleteActionCommandHandler(
        IActionRepository actionRepository,
        IUnitOfWork<QMSDbContext> uow,
        ILogger<DeleteActionCommandHandler> logger
        ) : IRequestHandler<DeleteActionCommand, ServiceResponse<ActionDto>>
    {
        public async Task<ServiceResponse<ActionDto>> Handle(DeleteActionCommand request, CancellationToken cancellationToken)
        {
            var entityExist = await actionRepository.FindAsync(request.Id);
            if (entityExist == null)
            {
                logger.LogError("Not found");
                return ServiceResponse<ActionDto>.Return404();
            }

            actionRepository.Delete(request.Id);

            if (await uow.SaveAsync(cancellationToken) <= 0)
            {
                return ServiceResponse<ActionDto>.Return500();
            }

            return ServiceResponse<ActionDto>.ReturnSuccess();
        }
    }
}
