﻿using AutoMapper;
using QualityManagement.Common.UnitOfWork;
using QualityManagement.Data.Dto;
using QualityManagement.Domain;
using QualityManagement.Helper;
using QualityManagement.Repository;
using MediatR;
using Microsoft.EntityFrameworkCore;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class UpdateAllowFileExtensionCommandHandler(IAllowFileExtensionRepository _allowFileExtensionRepository, IUnitOfWork<QMSDbContext> _uow, IMapper _mapper) : IRequestHandler<UpdateAllowFileExtensionCommand, ServiceResponse<AllowFileExtensionDto>>
    {
        public async Task<ServiceResponse<AllowFileExtensionDto>> Handle(UpdateAllowFileExtensionCommand request, CancellationToken cancellationToken)
        {
            var entityExist = await _allowFileExtensionRepository.All
                 .FirstOrDefaultAsync(c => c.FileType == request.FileType && c.Id != request.Id);
            if (entityExist != null)
            {
                return ServiceResponse<AllowFileExtensionDto>.Return409("File type with same name already exists.");
            }

            entityExist = await _allowFileExtensionRepository.All
                .FirstOrDefaultAsync(c => c.Id == request.Id);

            if (entityExist == null)
            {
                return ServiceResponse<AllowFileExtensionDto>.Return409("File type does not exists.");
            }

            entityExist.FileType = request.FileType;
            entityExist.Extension = request.Extension;
            _allowFileExtensionRepository.Update(entityExist);

            if (await _uow.SaveAsync() <= 0)
            {
                return ServiceResponse<AllowFileExtensionDto>.Return500();
            }

            var entityDto = _mapper.Map<AllowFileExtensionDto>(entityExist);
            return ServiceResponse<AllowFileExtensionDto>.ReturnResultWith200(entityDto);
        }
    }
}
