﻿using FluentValidation;
using NPOI.SS.Formula.Functions;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class AddAuditCommandValidator:AbstractValidator<AddAuditCommand>
    {
        public AddAuditCommandValidator()
        {
            RuleFor(c=>c.AuditorId).Must(NotEmptyGuid).WithMessage("Auditor Id is required");
            RuleFor(c=>c.AuditTemplateId).Must(NotEmptyGuid).NotEmpty().WithMessage("AuditTemplate Id is required");
        }
       
        private bool NotEmptyGuid(Guid p)
        {
            return p != Guid.Empty;
        }
        
    }
}
