﻿using Amazon.Runtime.Internal.Util;
using AutoMapper;
using MediatR;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using QualityManagement.Data.Dto;
using QualityManagement.Helper;
using QualityManagement.Repository;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class GetCapasByAuditIdCommandHandler(
        ICapaRequestRepository _capaRequestRepository,
        ILogger<GetCapasByAuditIdCommandHandler> _logger,
        IMapper _mapper) : IRequestHandler<GetCapasByAuditIdCommand, ServiceResponse<List<CapaRequestDto>>>
    {
        public async Task<ServiceResponse<List<CapaRequestDto>>> Handle(GetCapasByAuditIdCommand request, CancellationToken cancellationToken)
        {
            try
            {
                var entities=await _capaRequestRepository.All.Where(c=>c.AuditId==request.AuditId)
                    .Include(c=>c.RaisedBY)
                    .Include(c=>c.CapaActions)
                        .ThenInclude(c=>c.AssignTo)
                    .Include(c=>c.CapaActions)
                        .ThenInclude(c=>c.CreatedByUser)
                    .Include(c=>c.CapaAttachments)
                    .Include(c=>c.CapaReviews)
                    .Include(c=>c.CapaRootCauses)
                         .ThenInclude(c=>c.CreatedBy)
                    .Include(c=>c.CapaRootCauses)
                         .ThenInclude(c=>c.CapaRootCauseMethodology).ToListAsync();
                var dtos=_mapper.Map<List<CapaRequestDto>>(entities);
                return ServiceResponse<List<CapaRequestDto>>.ReturnResultWith200(dtos);
            }
            catch (System.Exception ex) 
            {
                _logger.LogError(ex,"error while getting Capa");
                return ServiceResponse<List<CapaRequestDto>>.Return500("");
            }
        }
    }
}
