﻿using Amazon.Runtime.Internal.Util;
using AutoMapper;
using MediatR;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using QualityManagement.Data.Dto;
using QualityManagement.Helper;
using QualityManagement.Repository;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class GetNcsByAuditIdCommandHandler(
        INonConformanceRepository _nonConformanceRepository,
        ILogger<GetNcsByAuditIdCommandHandler> _logger,
        IMapper _mapper) : IRequestHandler<GetNcsByAuditIdCommand, ServiceResponse<List<NonConformanceDto>>>
    {
        public async Task<ServiceResponse<List<NonConformanceDto>>> Handle(GetNcsByAuditIdCommand request, CancellationToken cancellationToken)
        {
            try
            {
                var entities = await _nonConformanceRepository.All
                    .Where(c => c.AuditId == request.AuditId)
                    .Include(c => c.ReportedBy)
                    .Include(c => c.Department)
                    .Include(c => c.NonConformanceResponses)
                            .ThenInclude(r => r.ResponsiblePerson)
                    .Include(c => c.NonConformanceResponses)
                            .ThenInclude(r => r.VerifiedBy)
                    .Include(c => c.NonConformanceResponses)
                            .ThenInclude(r => r.NonConformanceRespAttachments)
                    .Include(c => c.NonConformanceResponses)
                            .ThenInclude(r => r.ResponseType)
                            .ToListAsync(cancellationToken);
                var entitisDtos = _mapper.Map<List<NonConformanceDto>>(entities);
                return ServiceResponse<List<NonConformanceDto>>.ReturnResultWith200(entitisDtos);
            }
            catch (System.Exception ex)
            {
                _logger.LogError(ex, "error while getting NCs");
                return ServiceResponse<List<NonConformanceDto>>.Return500("error while getting NCs");
            }
        }
    }
}
