﻿using System;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;
using MediatR;
using Microsoft.EntityFrameworkCore;
using QualityManagement.Repository;

namespace QualityManagement.MediatR;

public class GetAuditComplianceRateCommandHandler(
    INonConformanceRepository _nonConformanceRepository,
    ICapaRequestRepository _capaRequestRepository,
    IAuditRepository _auditRepository) : IRequestHandler<GetAuditComplianceRateCommand, decimal>
{
    public async Task<decimal> Handle(GetAuditComplianceRateCommand request, CancellationToken cancellationToken)
    {
        var ncCount = await _nonConformanceRepository.All.Where(c => c.AuditId != null).CountAsync();
        var capaCount = await _capaRequestRepository.All.Where(c => c.AuditId != null).CountAsync();

        var audits = _auditRepository.All;

        if (request.StartDate.HasValue && request.EndDate.HasValue)
        {
            var startDate = request.StartDate.Value.Date;
            var endDate = request.EndDate.Value.Date.AddDays(1).AddTicks(-1);

            audits = audits.Where(c => c.CreatedDate >= startDate && c.CreatedDate <= endDate);
        }

        var auditCount = await audits.CountAsync();

        if (auditCount == 0)
            return 0;

        var totalIssues = ncCount + capaCount;

        // Basic inverse-compliance model
        var complianceRate = ((decimal)(auditCount - totalIssues) / auditCount) * 100;

        return Math.Round(complianceRate < 0 ? 0 : complianceRate, 2); // never go below 0%
    }

}
