﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;
using MediatR;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using QualityManagement.Data.Dto;
using QualityManagement.Data.Entities;
using QualityManagement.Repository;

namespace QualityManagement.MediatR;
public class GetAuditsForDropdownCommandHandler(
    IAuditRepository auditRepository,
    ILogger<GetAuditsForDropdownCommandHandler> logger) : IRequestHandler<GetAuditsForDropdownCommand, List<IdNameDto>>
{
    public async Task<List<IdNameDto>> Handle(GetAuditsForDropdownCommand request, CancellationToken cancellationToken)
    {
        try
        {
            var course = await auditRepository.All
                .Where(c => c.Status == AUDIT_STATUS.CREATED || c.Status == AUDIT_STATUS.INPROGRESS)
                .Select(d => new
                    IdNameDto
                {
                    Id = d.Id,
                    Name = d.Title
                })
                .ToListAsync();
            return course;
        }
        catch (Exception ex)
        {
            logger.LogError(ex, "Error occurred while handling GetAuditsForDropdownCommand");
            return [];
        }
    }
}
