﻿using System.Linq;
using System.Threading;
using System.Threading.Tasks;
using MediatR;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using QualityManagement.Common.UnitOfWork;
using QualityManagement.Data.Dto;
using QualityManagement.Domain;
using QualityManagement.Helper;
using QualityManagement.Repository;

namespace QualityManagement.MediatR;
public class DeleteAuditResponseAttachmentCommandHandler(
        IAuditResponseAttachmentRepository auditResponseAttachmentRepository,
        UserInfoToken userInfoToken,
        IUnitOfWork<QMSDbContext> uow,
        ILogger<DeleteAuditResponseAttachmentCommandHandler> logger
    ) : IRequestHandler<DeleteAuditResponseAttachmentCommand, ServiceResponse<AuditResponseAttachmentDto>>
{
    public async Task<ServiceResponse<AuditResponseAttachmentDto>> Handle(DeleteAuditResponseAttachmentCommand request, CancellationToken cancellationToken)
    {
        var entityExist = await auditResponseAttachmentRepository.All
            .Include(c => c.AuditResponse)
            .Where(c => c.Id == request.Id).FirstOrDefaultAsync();
        if (entityExist == null)
        {
            logger.LogError("Not found");
            return ServiceResponse<AuditResponseAttachmentDto>.Return404();
        }

        entityExist.IsDeleted = true;
        entityExist.ModifiedBy = userInfoToken.Id;
        entityExist.AuditResponse.Response = string.Join(",", entityExist.AuditResponse.Response.Split(',').Where(file => file != entityExist.FileName));
        auditResponseAttachmentRepository.Update(entityExist);
        if (await uow.SaveAsync(cancellationToken) <= 0)
        {
            return ServiceResponse<AuditResponseAttachmentDto>.Return500();
        }

        return ServiceResponse<AuditResponseAttachmentDto>.ReturnSuccess();
    }
}