﻿using System;
using FluentValidation;

namespace QualityManagement.MediatR;
internal class MarkAuditResponseAttachmentChunksUploadedCommandValidator : AbstractValidator<MarkAuditResponseAttachmentChunksUploadedCommand>
{
    public MarkAuditResponseAttachmentChunksUploadedCommandValidator()
    {
        RuleFor(c => c.AuditResponseAttachmentChunkId).Must(NotGuidEmpty).WithMessage("AuditResponseAttachment Id is required");
        RuleFor(c => c.Status).NotEmpty().WithMessage("status is required");
    }
    private bool NotGuidEmpty(Guid p)
    {
        return p != Guid.Empty;
    }
}