﻿using System;
using FluentValidation;

namespace QualityManagement.MediatR;
public class AddAuditReviewCommandValidator : AbstractValidator<AddAuditReviewCommand>
{
    public AddAuditReviewCommandValidator()
    {
        RuleFor(c => c.AuditId)
            .Must(NotEmptyGuid)
            .WithMessage("Audit Id is required");
        RuleFor(c => c.Status)
            .IsInEnum()
            .WithMessage("Status is required and must be a valid enum value");
    }
    private bool NotEmptyGuid(Guid p)
    {
        return p != Guid.Empty;
    }
}