﻿using System;
using FluentValidation;

namespace QualityManagement.MediatR;
public class AddAuditReviewerCommandValidator : AbstractValidator<AddAuditReviewerCommand>
{
    public AddAuditReviewerCommandValidator()
    {
        RuleFor(c => c.AuditId)
            .Must(NotEmptyGuid)
            .WithMessage("Audit Id is required");
        RuleFor(c => c.ReviewerId)
            .Must(NotEmptyGuid)
            .WithMessage("Reviewer Id is required");
    }
    private bool NotEmptyGuid(Guid p)
    {
        return p != Guid.Empty;
    }
}
