﻿using MediatR;
using Microsoft.EntityFrameworkCore;
using QualityManagement.Data.Dto;
using QualityManagement.Data.Entities;
using QualityManagement.Helper;
using QualityManagement.Repository;
using System.Collections.Generic;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR;
public class AuditDetailByStatusReviewCommand : IRequest<ServiceResponse<List<AuditReviewDetailDto>>>
{
}

public class AuditDetailByStatusReviewCommandHandler(
      IAuditReviewerRepository auditReviewerRepository,
       UserInfoToken userInfoToken
    ) : IRequestHandler<AuditDetailByStatusReviewCommand, ServiceResponse<List<AuditReviewDetailDto>>>
{
    public async Task<ServiceResponse<List<AuditReviewDetailDto>>> Handle(AuditDetailByStatusReviewCommand request, CancellationToken cancellationToken)
    {
        var auditReviewers = await auditReviewerRepository
            .All
            .Include(c => c.Submitter)
            .Include(c => c.Audit)
            .Where(c => c.ReviewerId == userInfoToken.Id
            && c.AuditStatus == AUDIT_STATUS.INREVIEW
            && c.Audit.Status == AUDIT_STATUS.INREVIEW)
            .OrderByDescending(c => c.ReviewedOn)
            .ToListAsync();

        var auditReviewersDtos = auditReviewers.Select(c => new AuditReviewDetailDto
        {
            Title = c.Audit.Title,
            Id = c.Audit.Id,
            AuditNumber = c.Audit.AuditNumber,
            ReviewedOn = c.ReviewedOn,
        }).ToList();

        return ServiceResponse<List<AuditReviewDetailDto>>.ReturnResultWith201(auditReviewersDtos);
    }

}
