﻿using System.Threading;
using System.Threading.Tasks;
using MediatR;
using Microsoft.Extensions.Logging;
using QualityManagement.Common.UnitOfWork;
using QualityManagement.Domain;
using QualityManagement.Helper;
using QualityManagement.Repository;

namespace QualityManagement.MediatR;

public class DeleteAuditTemplateCommandHandler(
    IAuditTemplateRepository _auditTemplateRepository,
    IUnitOfWork<QMSDbContext> _uow,
    ILogger<DeleteAuditTemplateCommandHandler> _logger) : IRequestHandler<DeleteAuditTemplateCommand, ServiceResponse<bool>>
{
    public async Task<ServiceResponse<bool>> Handle(DeleteAuditTemplateCommand request, CancellationToken cancellationToken)
    {
        try
        {
            var existEntity = await _auditTemplateRepository.FindAsync(request.Id);
            if (existEntity == null)
            {
                return ServiceResponse<bool>.Return404();
            }
            _auditTemplateRepository.Remove(existEntity);
            if (await _uow.SaveAsync() < 0)
            {
                return ServiceResponse<bool>.Return500();
            }
            return ServiceResponse<bool>.ReturnResultWith200(true);
        }
        catch (System.Exception ex)
        {
            _logger.LogError(ex, "Error while deleting AuditTemplate");
            return ServiceResponse<bool>.Return500("Error while deleting AuditTemplate");
        }
    }
}
