﻿using System.Collections.Generic;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;
using AutoMapper;
using MediatR;
using Microsoft.EntityFrameworkCore;
using QualityManagement.Data.Dto;
using QualityManagement.Helper;
using QualityManagement.Repository;

namespace QualityManagement.MediatR;
public record GetAuditQuestionsByTemplateIdCommandHandler(
    IAuditTemplateQuestionRepository auditTemplateQuestionRepository,
    IMapper _mapper) : IRequestHandler<GetAuditQuestionsByTemplateIdCommand, ServiceResponse<List<AuditTemplateQuestionDto>>>
{
    public async Task<ServiceResponse<List<AuditTemplateQuestionDto>>> Handle(GetAuditQuestionsByTemplateIdCommand request, CancellationToken cancellationToken)
    {
        var questions = await auditTemplateQuestionRepository.All
                .OrderBy(c => c.OrderNo)
            .Where(c => c.Id == request.TemplateId)
            .ToListAsync();
        if (questions == null || questions.Count == 0)
        {
            return ServiceResponse<List<AuditTemplateQuestionDto>>.Return404("No questions found for the given template ID.");
        }
        var questionsDto = _mapper.Map<List<AuditTemplateQuestionDto>>(questions);
        return ServiceResponse<List<AuditTemplateQuestionDto>>.ReturnResultWith200(questionsDto);
    }
}
