﻿using System.Linq;
using System.Threading;
using System.Threading.Tasks;
using AutoMapper;
using MediatR;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using QualityManagement.Data.Dto;
using QualityManagement.Data.Entities;
using QualityManagement.Helper;
using QualityManagement.Repository;

namespace QualityManagement.MediatR;

public class GetAuditTemplateCommandHandler(
    IAuditTemplateRepository _auditTemplateRepository,
    IMapper _mapper,
    ILogger<GetAuditTemplateCommandHandler> _logger) : IRequestHandler<GetAuditTemplateCommand, ServiceResponse<AuditTemplateDto>>
{
    public async Task<ServiceResponse<AuditTemplateDto>> Handle(GetAuditTemplateCommand request, CancellationToken cancellationToken)
    {
        try
        {
            var existEntity = await _auditTemplateRepository.All
            .Include(a => a.Questions)
                .ThenInclude(c => c.QuestionOptions)
            .Include(d => d.Audits)
            .Where(a => a.Id == request.Id)
            .FirstOrDefaultAsync();

            if (existEntity == null)
            {
                return ServiceResponse<AuditTemplateDto>.Return404();
            }
            var entityDto = _mapper.Map<AuditTemplateDto>(existEntity);
            entityDto.AuditId = existEntity.Audits
                       .Where(a => a.AuditTemplateId == request.Id &&
                                   (a.Status == AUDIT_STATUS.CREATED || a.Status == AUDIT_STATUS.INPROGRESS))
                       .Select(a => a.Id)
                       .FirstOrDefault();
            return ServiceResponse<AuditTemplateDto>.ReturnResultWith200(entityDto);
        }
        catch (System.Exception ex)
        {
            _logger.LogError(ex, "Error while get AuditTemplate");
            return ServiceResponse<AuditTemplateDto>.Return500("Error while get AuditTemplate");
        }

    }
}
