﻿using DocumentFormat.OpenXml.Spreadsheet;
using FluentValidation;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class UpdateAuditTemplateValidatorCommand : AbstractValidator<UpdateAuditTemplateCommand>
    {
        public UpdateAuditTemplateValidatorCommand()
        {
            RuleFor(c => c.Id).Must(NotEmptyGuid).WithMessage("Id is Required");
            RuleFor(c => c.Name).NotEmpty().WithMessage("Name is required");
        }

        private bool NotEmptyGuid(Guid p)
        {
            return p != Guid.Empty;
        }

    }
}
