﻿using Amazon.Runtime.Internal.Util;
using AutoMapper;
using MediatR;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using QualityManagement.Data.Dto;
using QualityManagement.Helper;
using QualityManagement.Repository;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class GetAllAsignCapaActionsCommandHandler(
        ICapaRequestRepository _capaRequestRepository,
        UserInfoToken _userInfoToken,
        IMapper _mapper,
        ILogger<GetAllAsignCapaActionsCommandHandler> _logger) : IRequestHandler<GetAllAsignCapaActionsCommand, ServiceResponse<List<CapaRequestDto>>>
    {
        public async Task<ServiceResponse<List<CapaRequestDto>>> Handle(GetAllAsignCapaActionsCommand request, CancellationToken cancellationToken)
        {
            try
            {
                var entities = await _capaRequestRepository
                    .All.Where(c => c.CapaActions.Any(c => c.AssignToId == _userInfoToken.Id) &&
                    c.CapaRequestStatus != Data.Entities.CapaRequestStatus.CLOSED &&
                    c.CapaRequestStatus != Data.Entities.CapaRequestStatus.REJECTED)
                    .Include(c => c.RaisedBY)
                    .Include(c => c.CapaActions.Where(c => c.AssignToId == _userInfoToken.Id))
                       .ThenInclude(c => c.CreatedByUser)
                    .Include(c => c.CapaActions.Where(c => c.AssignToId == _userInfoToken.Id))
                      .ThenInclude(c => c.AssignTo).ToListAsync();

                var entityDtos = _mapper.Map<List<CapaRequestDto>>(entities);

                return ServiceResponse<List<CapaRequestDto>>.ReturnResultWith200(entityDtos);
            }
            catch (System.Exception ex)
            {
                _logger.LogError(ex, "error while gettinga All assign Capa Actions");
                return ServiceResponse<List<CapaRequestDto>>.Return500("error while gettinga All assign Capa Actions");
            }

        }
    }
}
