﻿using AutoMapper;
using MediatR;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using QualityManagement.Data.Dto;
using QualityManagement.Helper;
using QualityManagement.Repository;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class GetAllCapaActionCommandHandler(
        ICapaActionRepository _capaActionRepository,
        IMapper _mapper,
        ILogger<GetAllCapaActionCommandHandler> _logger
        ) : IRequestHandler<GetAllCapaActionCommand, ServiceResponse<List<CapaActionDto>>>
    {
        public async Task<ServiceResponse<List<CapaActionDto>>> Handle(GetAllCapaActionCommand request, CancellationToken cancellationToken)
        {
            try
            {
                
               var entity=await _capaActionRepository.All
                    .Include(c=>c.AssignTo)
                    .Include(c=>c.CreatedByUser)
                    .Where(c=>c.CapaRequestId==request.CapaRequestId).ToListAsync();

                var entitiesDto = _mapper.Map<List<CapaActionDto>>(entity);
                return ServiceResponse<List<CapaActionDto>>.ReturnResultWith200(entitiesDto);
            }
            catch (System.Exception ex)
            {
                _logger.LogError(ex, "Error while getting CapaAction");
                return ServiceResponse<List<CapaActionDto>>.Return500("Error while getting CapaAction");
            }
           
        }
    }
}
