﻿using System.Threading;
using System.Threading.Tasks;
using MediatR;
using Microsoft.Extensions.Logging;
using QualityManagement.Common.UnitOfWork;
using QualityManagement.Data.Dto;
using QualityManagement.Domain;
using QualityManagement.Helper;
using QualityManagement.Repository;

namespace QualityManagement.MediatR;
public class DeleteCapaAttachmentCommandHandler(
     ICapaAttachmentRepository capaAttachmentRepository,
        IUnitOfWork<QMSDbContext> uow,
        ILogger<DeleteCapaAttachmentCommandHandler> logger
    ) : IRequestHandler<DeleteCapaAttachmentCommand, ServiceResponse<CapaAttachmentDto>>
{
    public async Task<ServiceResponse<CapaAttachmentDto>> Handle(DeleteCapaAttachmentCommand request, CancellationToken cancellationToken)
    {
        var entityExist = await capaAttachmentRepository.FindAsync(request.Id);
        if (entityExist == null)
        {
            logger.LogError("Not found");
            return ServiceResponse<CapaAttachmentDto>.Return404();
        }
        capaAttachmentRepository.Delete(entityExist);
        if (await uow.SaveAsync(cancellationToken) <= 0)
        {
            return ServiceResponse<CapaAttachmentDto>.Return500();
        }

        return ServiceResponse<CapaAttachmentDto>.ReturnSuccess();
    }
}