﻿using Amazon.Runtime.Internal.Util;
using MediatR;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using QualityManagement.Common.UnitOfWork;
using QualityManagement.Data.Entities;
using QualityManagement.Domain;
using QualityManagement.Helper;
using QualityManagement.Repository;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR.Capa
{
    public class GetDocumentTokenByDocumentIdCommandHandler(
        IUnitOfWork<QMSDbContext> _uow,
        IDocumentTokenRepository _documentTokenRepository,
        ILogger<GetDocumentTokenByDocumentIdCommandHandler> _logger) : IRequestHandler<GetDocumentTokenByDocumentIdCommand, ServiceResponse<string>>
    {
        public async Task<ServiceResponse<string>> Handle(GetDocumentTokenByDocumentIdCommand request, CancellationToken cancellationToken)
        {
            var token = Guid.NewGuid();
            var documentToken = await _documentTokenRepository.All.FirstOrDefaultAsync(c => c.DocumentId == request.Id);
            if (documentToken == null)
            {
                _documentTokenRepository.Add(new DocumentToken
                {
                    CreatedDate = DateTime.UtcNow,
                    DocumentId = request.Id,
                    Token = token
                });
                await _uow.SaveAsync();
            }
            else
            {
                token = documentToken.Token;
            }
            return ServiceResponse<string>.ReturnResultWith200(token.ToString());
        }
    }
}
