﻿using MediatR;
using Microsoft.EntityFrameworkCore;
using QualityManagement.Data.Entities;
using QualityManagement.Repository;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class GetCapaOnTimeCompletionCommandHandler(
        ICapaRequestRepository _capaRequestRepository) : IRequestHandler<GetCapaOnTimeCompletionCommand, decimal>
    {
        public async Task<decimal> Handle(GetCapaOnTimeCompletionCommand request, CancellationToken cancellationToken)
        {
            var totalCapa = await _capaRequestRepository.All
                .Where(c=>c.CapaRequestStatus==CapaRequestStatus.CLOSED)
                .Select(c => new
                {
                    c.CapaRequestStatus,
                    c.ModifiedDate,
                    c.DueDate
                })
                .ToListAsync();
           
            var capaOnTime = totalCapa.Where(c => c.CapaRequestStatus == CapaRequestStatus.CLOSED && c.ModifiedDate <= c.DueDate).Count();
            if (capaOnTime == 0 || totalCapa.Count == 0)
            {
                return 0;
            }
            decimal capaCompleteOnTime = Math.Round(((decimal)capaOnTime / totalCapa.Count) * 100, 2);
            return capaCompleteOnTime;
        }
    }
}
