﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;
using MediatR;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using QualityManagement.Data.Dto;
using QualityManagement.Data.Entities;
using QualityManagement.Repository;

namespace QualityManagement.MediatR;
public class GetCapaOverviewCommandHandler(
   ICapaRequestRepository capaRequestRepository,
   ILogger<GetNonConformanceOverviewCommandHandler> logger) : IRequestHandler<GetCapaOverviewCommand, List<NameCountDto>>
{
    public async Task<List<NameCountDto>> Handle(GetCapaOverviewCommand request, CancellationToken cancellationToken)
    {
        try
        {
            IQueryable<CapaRequest> capaRequests;

            if (request.FromDate.HasValue && request.ToDate.HasValue)
            {
                var startDate = request.FromDate.Value;
                var endDate = request.ToDate.Value;

                DateTime minDate = new DateTime(startDate.Year, startDate.Month, startDate.Day, 0, 0, 0);
                DateTime maxDate = new DateTime(endDate.Year, endDate.Month, endDate.Day, 23, 59, 59);

                capaRequests = capaRequestRepository.All
                    .Where(c => c.CreatedDate >= minDate && c.CreatedDate <= maxDate);
            }
            else
            {
                capaRequests = capaRequestRepository.All;
            }

            var capaRequestOverview = await capaRequests
               .GroupBy(a => a.CapaRequestStatus)
               .Select(g => new NameCountDto
               {
                   Name = g.Key.ToString(),
                   Count = g.Count()
               })
               .ToListAsync(cancellationToken);

            return capaRequestOverview;
        }
        catch (Exception ex)
        {
            logger.LogError(ex, "Error occurred while handling GetCapaOverviewCommand");
            return new List<NameCountDto>();
        }
    }
}