﻿using System.Linq;
using System.Threading;
using System.Threading.Tasks;
using AutoMapper;
using MediatR;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using QualityManagement.Data.Dto;
using QualityManagement.Helper;
using QualityManagement.Repository;

namespace QualityManagement.MediatR;

public class GetCapaRequestCommandHandler(
    ICapaRequestRepository _capaRequestRepository,
    ILogger<GetCapaRequestCommandHandler> _logger,
    IMapper _mapper) : IRequestHandler<GetCapaRequestCommand, ServiceResponse<CapaRequestDto>>
{
    public async Task<ServiceResponse<CapaRequestDto>> Handle(GetCapaRequestCommand request, CancellationToken cancellationToken)
    {
        try
        {
            var existEntity = await _capaRequestRepository.All
                .Include(c => c.NonConformance)
                .Include(c => c.Audit)
                .Include(c => c.RaisedBY)
                .Where(c => c.Id == request.Id)
                .FirstOrDefaultAsync();
            if (existEntity == null)
            {
                return ServiceResponse<CapaRequestDto>.Return404("CapaRequest not found");
            }
            var entityDto = _mapper.Map<CapaRequestDto>(existEntity);
            return ServiceResponse<CapaRequestDto>.ReturnResultWith200(entityDto);
        }
        catch (System.Exception ex)
        {
            _logger.LogError(ex, "Error while getting CapaRequest.");
            return ServiceResponse<CapaRequestDto>.Return500("Error while getting CapaRequest.");
        }

    }
}
