﻿using MediatR;
using QualityManagement.Repository;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class GetCapaRequestListCommandHandler(
        ICapaRequestRepository _capaRequestRepository) : IRequestHandler<GetCapaRequestListCommand, CapaRequestList>
    {
        public async Task<CapaRequestList> Handle(GetCapaRequestListCommand request, CancellationToken cancellationToken)
        {
            return await _capaRequestRepository.GetCapaRequest(request.CapaRequestResource);
        }
    }
}
