﻿using System;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;
using AutoMapper;
using MediatR;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using QualityManagement.Common.UnitOfWork;
using QualityManagement.Data.Dto;
using QualityManagement.Data.Entities;
using QualityManagement.Domain;
using QualityManagement.Helper;
using QualityManagement.Repository;

namespace QualityManagement.MediatR;

public class AddCapaRootCauseMethodologyCommandHandler(
    ICapaRootCauseMethodologyRepository _capaRootCauseMethodologyRepository,
    IMapper _mapper,
    IUnitOfWork<QMSDbContext> _uow,
    ILogger<AddCourseCommandHandler> logger) : IRequestHandler<AddCapaRootCauseMethodologyCommand, ServiceResponse<CapaRootCauseMethodologyDto>>
{
    public async Task<ServiceResponse<CapaRootCauseMethodologyDto>> Handle(AddCapaRootCauseMethodologyCommand request, CancellationToken cancellationToken)
    {
        try
        {
            var existingEntity = await _capaRootCauseMethodologyRepository.All
                .Where(s => s.Name.ToLower() == request.Name.ToLower()).FirstOrDefaultAsync();
            if (existingEntity != null)
            {
                return ServiceResponse<CapaRootCauseMethodologyDto>.Return409("CapaRootCauseMethodology name is already exist");
            }

            var entity = _mapper.Map<CapaRootCauseMethodology>(request);
            entity.Id = Guid.NewGuid();

            _capaRootCauseMethodologyRepository.Add(entity);
            if (await _uow.SaveAsync(cancellationToken) < 0)
            {
                return ServiceResponse<CapaRootCauseMethodologyDto>.Return500();
            }
            var entityDto = _mapper.Map<CapaRootCauseMethodologyDto>(entity);
            return ServiceResponse<CapaRootCauseMethodologyDto>.ReturnResultWith201(entityDto);
        }
        catch (System.Exception ex)
        {
            logger.LogError(ex, "Error while saving CapaRootCauseMethodology");
            return ServiceResponse<CapaRootCauseMethodologyDto>.Return500("Error while saving CapaRootCauseMethodology");
        }

    }
}
