﻿using MediatR;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using QualityManagement.Common.UnitOfWork;
using QualityManagement.Domain;
using QualityManagement.Helper;
using QualityManagement.Repository;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class DeleteCapaRootCauseMethodologyCommandHandler(
        ICapaRootCauseMethodologyRepository _capaRootCauseMethodologyRepository,
        IUnitOfWork<QMSDbContext> _uow,
         ILogger<DeleteActionCommandHandler> logger) : IRequestHandler<DeleteCapaRootCauseMethodologyCommand, ServiceResponse<bool>>
    {
        public async Task<ServiceResponse<bool>> Handle(DeleteCapaRootCauseMethodologyCommand request, CancellationToken cancellationToken)
        {
            try
            {
                var entityExit = await _capaRootCauseMethodologyRepository.All
                   .FirstOrDefaultAsync(c => c.Id == request.Id);
                if (entityExit == null)
                {
                    return ServiceResponse<bool>.Return404();
                }
                _capaRootCauseMethodologyRepository.Remove(entityExit);
                if (await _uow.SaveAsync(cancellationToken) < 0)
                {
                    return ServiceResponse<bool>.Return500();
                }
                return ServiceResponse<bool>.ReturnResultWith200(true);
            }
            catch (System.Exception ex)
            {
                logger.LogError(ex, "Error while deleting CapaRootCauseMethodology");
                return ServiceResponse<bool>.Return500("Error while deleting CapaRootCauseMethodology");
            }
        }


    }
}

