﻿using System.Threading;
using System.Threading.Tasks;
using AutoMapper;
using MediatR;
using Microsoft.Extensions.Logging;
using QualityManagement.Data.Dto;
using QualityManagement.Helper;
using QualityManagement.Repository;

namespace QualityManagement.MediatR;

public class GetCapaRootCauseMethodologyCommandHandler(
    ICapaRootCauseMethodologyRepository _capaRootCauseMethodologyRepository,
    IMapper _mapper,
    ILogger<GetCapaRootCauseMethodologyCommandHandler> _logger) : IRequestHandler<GetCapaRootCauseMethodologyCommand, ServiceResponse<CapaRootCauseMethodologyDto>>
{
    public async Task<ServiceResponse<CapaRootCauseMethodologyDto>> Handle(GetCapaRootCauseMethodologyCommand request, CancellationToken cancellationToken)
    {
        try
        {
            var entity = await _capaRootCauseMethodologyRepository.FindAsync(request.Id);
            if (entity == null)
            {
                return ServiceResponse<CapaRootCauseMethodologyDto>.Return404("Not Found");
            }
            var entityDto = _mapper.Map<CapaRootCauseMethodologyDto>(entity);
            return ServiceResponse<CapaRootCauseMethodologyDto>.ReturnResultWith200(entityDto);
        }
        catch (System.Exception ex)
        {
            _logger.LogError(ex, " Error while Get CapaRootCauseMethodology");
            return ServiceResponse<CapaRootCauseMethodologyDto>.Return500();
        }

    }
}
