﻿using FluentValidation;
using System;

namespace QualityManagement.MediatR
{
    public class AddCapaRootCauseCommandValidator : AbstractValidator<AddCapaRootCauseCommand>
    {
        public AddCapaRootCauseCommandValidator()
        {
            RuleFor(c => c.CapaRequestId).Must(GuidNotEmpty).WithMessage("CapaRequest id is required");
        }
        private bool GuidNotEmpty(Guid p)
        {
            return p != Guid.Empty;
        }
    }
}
