﻿using AutoMapper;
using MediatR;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using QualityManagement.Data.Dto;
using QualityManagement.Helper;
using QualityManagement.Repository;
using System.Collections.Generic;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class GetCapaRootCauseCommandHandler(
        ICapaRootCauseRepository _capaRootCauseRepository,
        IMapper _mapper,
        ILogger<GetCapaRootCauseCommandHandler> _logger) : IRequestHandler<GetCapaRootCauseCommand, ServiceResponse<List<CapaRootCauseDto>>>
    {
        public async Task<ServiceResponse<List<CapaRootCauseDto>>> Handle(GetCapaRootCauseCommand request, CancellationToken cancellationToken)
        {
            try
            {
                var entities = await _capaRootCauseRepository
               .All
               .Include(c => c.CapaRootCauseMethodology)
               .Include(c => c.CreatedBy)
               .Where(c => c.CapaRequestId == request.CapaRequestId)
               .ToListAsync();

                var EntitiesDto = _mapper.Map<List<CapaRootCauseDto>>(entities);
                return ServiceResponse<List<CapaRootCauseDto>>.ReturnResultWith200(EntitiesDto);
            }
            catch (System.Exception ex)
            {
                _logger.LogError(ex, "Error while getting CapaRootCause");
                return ServiceResponse<List<CapaRootCauseDto>>.Return500("Error while getting CapaRootCause");
            }

        }
    }
}
