﻿using FluentValidation;
using System;

namespace QualityManagement.MediatR
{
    public class UpdateCapaRootCauseCommandValidator : AbstractValidator<UpdateCapaRootCauseCommand>
    {
        public UpdateCapaRootCauseCommandValidator()
        {
            RuleFor(c => c.Id).Must(GuidNotEmpty).WithMessage("id is required");
            RuleFor(c => c.CapaRequestId).Must(GuidNotEmpty).WithMessage("CapaRequest id is required");
        }
        private bool GuidNotEmpty(Guid p)
        {
            return p != Guid.Empty;
        }
    }
}
