﻿using MediatR;
using QualityManagement.Data.Dto;
using QualityManagement.Helper;
using QualityManagement.Repository;
using System.Collections.Generic;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR;
public class GetAllDescendantsUsingCTEByParentIdCommandHandler(ICategoryRepository categoryRepository) : IRequestHandler<GetAllDescendantsUsingCTEByParentIdCommand, ServiceResponse<List<CategoryDto>>>
{
    public async Task<ServiceResponse<List<CategoryDto>>> Handle(GetAllDescendantsUsingCTEByParentIdCommand request, CancellationToken cancellationToken)
    {
        var categories = categoryRepository.GetAllDescendantsUsingCTEByParentId(request.ParentId);

        return ServiceResponse<List<CategoryDto>>.ReturnResultWith200(categories);
    }
}
